package main

import (
	"fmt"
	"math"
	"sync"
)

/*
3. Utwórz funkcję definiującą mapę, map[int]float64, której klucze są liczbami z prze-działu od 0 (włącznie) do 100 000 (bez tej wartości), natomiast wartościami są pierwiastki kwadratowe tych liczb. Do obliczenia pierwiastków kwadratowych skorzystaj z funkcji math.sqrt (https://pkg.go.dev/math#Sqrt). Za pomocą sync.OnceValue wygeneruj funkcję, która będzie buforowała instancję map zwróco-ną przez tę funkcję. Użyj buforowanej wartości do wyszukania pierwiastków kwadratowych dla każdej co 100 liczby w podanym przedziale.
*/
func buildSquareRootMap() map[int]float64 {
	out := make(map[int]float64, 100_000)
	for i := 0; i < 100_000; i++ {
		out[i] = math.Sqrt(float64(i))
	}
	return out
}

var squareRootMapCache = sync.OnceValue(buildSquareRootMap)

func main() {
	for i := 0; i < 100_000; i += 1_000 {
		fmt.Println(i, squareRootMapCache()[i])
	}
}
